/*
 * Decompiled with CFR 0.152.
 */
package ibm.nways.jdm;

import ibm.nways.jdm.BrowserApplet;
import ibm.nways.jdm.GraphicAction;
import ibm.nways.jdm.GraphicContainer;
import ibm.nways.jdm.GraphicElement;
import ibm.nways.jdm.GraphicFlyOver;
import ibm.nways.jdm.HasJmaPopup;
import java.awt.Component;
import java.awt.Container;
import java.awt.Cursor;
import java.awt.MenuItem;
import java.awt.Point;
import java.awt.PopupMenu;
import java.awt.event.MouseEvent;
import java.awt.event.MouseMotionListener;

public abstract class GraphicComponent
extends Component
implements GraphicElement,
HasJmaPopup,
MouseMotionListener {
    protected int zOrder;
    protected GraphicAction action;
    protected GraphicFlyOver flyOver;
    protected PopupMenu popup;
    protected BrowserApplet browserApplet;

    public GraphicComponent() {
        this.enableEvents(16L);
        this.addMouseMotionListener(this);
        this.popup = this.getNewPopupMenu();
    }

    public int getZOrder() {
        return this.zOrder;
    }

    public void setZOrder(int n) {
        this.zOrder = n;
        Container container = this.getParent();
        if (container != null && container instanceof GraphicContainer) {
            ((GraphicContainer)container).updatedZOrder(this);
        }
    }

    public Point getRelativePosition() {
        return this.getLocation();
    }

    public void setRelativePosition(Point point) {
        this.setLocation(point);
    }

    public GraphicAction getAction() {
        return this.action;
    }

    public void setAction(GraphicAction graphicAction) {
        this.action = graphicAction;
        if (graphicAction != null) {
            this.setCursor(new Cursor(12));
            return;
        }
        this.setCursor(new Cursor(0));
    }

    public void doAction() {
        if (this.action != null) {
            this.action.doAction(this);
        }
    }

    public GraphicFlyOver getFlyOver() {
        return this.flyOver;
    }

    public void setFlyOver(GraphicFlyOver graphicFlyOver) {
        this.flyOver = graphicFlyOver;
    }

    protected void processMouseEvent(MouseEvent mouseEvent) {
        switch (mouseEvent.getID()) {
            case 500: {
                this.mouseClicked(mouseEvent);
                break;
            }
            case 504: {
                this.mouseEntered(mouseEvent);
                break;
            }
            case 505: {
                this.mouseExited(mouseEvent);
                break;
            }
            case 502: {
                this.mouseReleased(mouseEvent);
                break;
            }
            case 501: {
                this.mousePressed(mouseEvent);
            }
        }
        super.processMouseEvent(mouseEvent);
    }

    private void mouseClicked(MouseEvent mouseEvent) {
        if (mouseEvent.getClickCount() == 2) {
            this.doAction();
        }
    }

    private void mouseEntered(MouseEvent mouseEvent) {
    }

    private void mouseExited(MouseEvent mouseEvent) {
        this.killFlyOver();
    }

    public void mouseMoved(MouseEvent mouseEvent) {
        if (this.flyOver != null && this.flyOver.isEnabled()) {
            this.startFlyOver(mouseEvent.getPoint());
        }
    }

    public void mouseDragged(MouseEvent mouseEvent) {
        this.killFlyOver();
    }

    private void mouseReleased(MouseEvent mouseEvent) {
        this.checkPopup(mouseEvent);
    }

    private void mousePressed(MouseEvent mouseEvent) {
        this.checkPopup(mouseEvent);
    }

    private void checkPopup(MouseEvent mouseEvent) {
        if (mouseEvent.isPopupTrigger()) {
            this.killFlyOver();
            this.previewPopup(this.popup);
            PopupThread popupThread = new PopupThread(this.popup, mouseEvent);
            popupThread.start();
        }
    }

    private synchronized void killFlyOver() {
        if (this.browserApplet == null) {
            this.browserApplet = this.getBrowserApplet();
        }
        if (this.browserApplet != null) {
            this.browserApplet.setComponentWithFlyOver(null);
        }
    }

    private synchronized void startFlyOver(Point point) {
        if (this.browserApplet == null) {
            this.browserApplet = this.getBrowserApplet();
        }
        if (this.browserApplet != null) {
            this.browserApplet.setComponentWithFlyOver(this, point);
        }
    }

    protected BrowserApplet getBrowserApplet() {
        Container container = this.getParent();
        while (container != null) {
            if (!((container = container.getParent()) instanceof BrowserApplet)) continue;
            return (BrowserApplet)container;
        }
        return null;
    }

    public PopupMenu getNewPopupMenu() {
        return new PopupMenu();
    }

    public void addPopupMenuItem(MenuItem menuItem) {
        if (this.popup != null) {
            this.popup.add(menuItem);
        }
    }

    public void removePopupMenuItem(MenuItem menuItem) {
        if (this.popup != null) {
            this.popup.remove(menuItem);
        }
    }

    protected void previewPopup(PopupMenu popupMenu) {
    }

    public void dispose() {
        if (this.popup != null && this.browserApplet != null) {
            this.browserApplet.getParent().remove(this.popup);
        }
        this.action = null;
        this.flyOver = null;
        this.popup = null;
        this.browserApplet = null;
    }

    public void reallyDispose() {
        this.dispose();
    }

    class PopupThread
    extends Thread {
        PopupMenu popup;
        MouseEvent e;

        PopupThread(PopupMenu popupMenu, MouseEvent mouseEvent) {
            GraphicComponent.this = GraphicComponent.this;
            this.popup = popupMenu;
            this.e = mouseEvent;
            if (GraphicComponent.this.browserApplet == null) {
                GraphicComponent.this.browserApplet = GraphicComponent.this.getBrowserApplet();
            }
            GraphicComponent.this.browserApplet.getParent().add(popupMenu);
        }

        public void run() {
            this.popup.show(this.e.getComponent(), this.e.getX(), this.e.getY());
        }
    }
}

